/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: ConfigLockDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Configuration Lock Get/Set Test dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-07-25  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file ConfigLockeDlg.h
///   Configuration Lock Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// Configuration Lock Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CConfigLockDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CConfigLockDlg)

public:
	CConfigLockDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CConfigLockDlg();

// Dialog Data
	enum { IDD = IDD_CONFIGLOCK };

protected:
  unsigned long   m_ulSetTimeout;   //!< Timeout when calling Set Host State
  CComboBox       m_cNewStateCtrl;  //!< Set Host State Combobox Control

  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();

  virtual void ThreadFunction(void);
  virtual void OnUpdateDevice(CCifXDeviceBase* pcDevice);
};
